/**
 * @file
 * Global utilities.
 *
 */
(function($, Drupal) {
  'use strict';
  Drupal.behaviors.tu_boleta_theme = {
    attach: function(context, settings) {
      $('.featured-event-show-more-btn', context).click(function(){
        $('.featured-events .field--name-field-content-reference .field__item').removeClass('position-absolute opacity-0 hidden_event');
        $('.featured-event-show-more-btn').addClass('d-none');
      });

      once('dropdown-menu-headers', 'ul.nav li.dropdown', context).forEach(selector => {
        selector.addEventListener('mouseover', event => {
          event.currentTarget.getElementsByClassName('dropdown-menu dropdown-menu-header')[0].classList.add('show');
        }, false);
        selector.addEventListener('mouseout', event => {
          event.currentTarget.getElementsByClassName('dropdown-menu dropdown-menu-header')[0].classList.remove('show');
        }, false);
      });
    }
  };

  $(document).ready(function() {
    const isTouchDevice = 'ontouchstart' in window || navigator.maxTouchPoints > 0;
    if (isTouchDevice) {
      $('.tooltip-button').on('click touchstart', function(e) {
        e.preventDefault();
        e.stopPropagation();
  
        const $tooltip = $(this);
  
        $('.tooltip-button').not($tooltip).removeClass('active');
  
        $tooltip.toggleClass('active');
      });
  
      $(document).on('click touchstart', function() {
        $('.tooltip-button').removeClass('active');
      });
    }

  });
 

})(jQuery, Drupal);
